#!/bin/sh

if [ $# != 1 ]; then
    echo "Usage $0 <path-to-bsp-files>"
    logger "$0 missing cmdline argument"
    exit 1
fi

if [ ! -d $1 ]; then
    logger "$0: path ${1} does not exist"
    exit 2
fi

UPLOADPATH="/var/lib/sftp/upload/"
UPLOADFILES_AM335X_MOBILE="\
                           core-image-mahr-mobile-mahr-am335x-mobile.ext4.gz \
                           core-image-mahr-updater-mahr-am335x-mobile.cpio.gz.u-boot \
                           uImage-m310.dtb \
                           uImage-mahr-am335x-mobile.bin"

UPLOADFILES_AM335X_MOBILE_OPTIONAL="u-boot.img-m310 MLO-m310"

for F in ${UPLOADFILES_AM335X_MOBILE}; do
    if [ ! -e ${1}/${F} ]; then
        logger "$0: ${F} not found in ${1}"
        exit 3
    fi
done

if [ -e ${1}/u-boot.img-m310 -a -e ${1}/MLO-m310 ]; then
    UPLOADFILES_AM335X_MOBILE="${UPLOADFILES_AM335X_MOBILE} u-boot.img-m310 MLO-m310"
fi

for F in ${UPLOADFILES_AM335X_MOBILE}; do
    cp ${1}/${F} ${UPLOADPATH}
    if [ $? != 0 ]; then
        logger "$0: cp ${1}/${F} -> ${UPLOADPATH} failed"
        exit 4
    fi
done
sync

mount -o remount,rw /bootldr

cat <<EOF > /bootldr/uEnv.txt
uenvcmd=run updload upgrade ramargs bootmrd
upath=/upload
upgrade=setenv optargs \${optargs} installer.mode=upgrade installer.path=\${upath}
updload=ext2load mmc \${mmcdev}:4 \${kernel_addr_r} \${upath}/\${usbimg};ext2load mmc \${mmcdev}:4 \${dtb_addr_r} \${upath}/\${usbdtb};ext2load mmc \${mmcdev}:4 \${initrd_addr_r} \${upath}/\${usbinitrd}
EOF

mount -o remount,ro /bootldr

exit 0
